﻿<%@ import Namespace="System.Diagnostics" %>
<%@ import Namespace="Soneta.Tools" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Kalend" %>
<%@ import Namespace="Soneta.Kadry" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Page Language="c#" autoeventwireup="false" CodePage="1200" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>Ewidencja czasu pracy</title>
		<script runat="server">

    public class Params: ContextBase {
    
        public Params(Context context): base(context) {
            Date data = ((ActualDate)Context[typeof(ActualDate)]).Actual;
            okres = new YearMonth(data).ToFromTo();
        }
    
        FromTo okres;
        [Required]
        [Caption("Raport za okres")]
        [Priority(1)]
        public FromTo Okres {
            get { return okres; }
            set {
                okres = value;
                OnChanged(EventArgs.Empty);
            }
        }
    }
        
    Params pars;
    [Context]
    public Params Pars {
        set { pars = value; }
    }
        
    void OnContextLoad(Object sender, EventArgs e) {
		ReportHeader1["OKRES"] = pars.Okres.ToString();
		ArrayList lista = new ArrayList();
		Row[] rows = (Row[])dc[typeof(Row[])];
		foreach (Pracownik idx in rows) {
			KalkulatorPracy kp = new KalkulatorPracy(idx);			
			foreach (INieobecnosc n in kp.Nieobecnosci(pars.Okres, true)) 
				lista.Add(n);			
		}
		
		Grid1.DataSource = lista;
    }
    
    void Grid1_BeforeRow(Object sender, RowEventArgs args) {
        OkresNieobecności on = (OkresNieobecności)args.Row;
        Nieobecnosc n = (Nieobecnosc)on;
        if (n.Zwolnienie.Przyczyna!=0)
			colPrzyczyna.EditValue = CaptionAttribute.EnumToString(n.Zwolnienie.Przyczyna);
		else if (n.Urlop.Przyczyna!=0)
			colPrzyczyna.EditValue = CaptionAttribute.EnumToString(n.Urlop.Przyczyna);
        if (n.Definicja.Typ == TypNieobecnosci.NieobecnośćZUS) {
            colDniKalend.EditValue = on.Okres.Days;
            colDniPracy.EditValue = "-";
            colCzas.EditValue = "-";
            colLSzpitalne.EditValue = on.Zwolnienie.LeczenieSzpitalne? "Tak": "Nie";
        } else {
            colDniKalend.EditValue = "-";
            if (n.Norma == Time.Empty) {
                colDniPracy.EditValue = on.Norma().Dni;
                colCzas.EditValue = "-";
            }
            else {
                colDniPracy.EditValue = "-";
                colCzas.EditValue = on.Norma().Czas;
            }
        }
	}
    
    static void Msg(object value) {
    }

		</script>
		<meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<body>
		<form id="EwidencjaCzasuPracy" method="post" runat="server">
			<ea:datacontext id="dc" runat="server" TypeName="Soneta.Business.Row[], Soneta.Business" oncontextload="OnContextLoad"></ea:datacontext><cc1:reportheader NagłówekOddziału="NagłówekOddziału" id="ReportHeader1" title="Lista nieobecności|</strong>Za okres:<strong> %OKRES%"
				runat="server"></cc1:reportheader><ea:grid id="Grid1" runat="server" OnBeforeRow="Grid1_BeforeRow" RowTypeName="Soneta.Kalend.INieobecnosc,Soneta.KadryPlace"
				GroupData0="Pracownik.NazwiskoImię" GroupData1="Pracownik.Kod" GroupLine="{0} ({1})">
				<Columns>
					<ea:GridColumn Width="4" Align="Right" DataMember="#" Caption="Lp."></ea:GridColumn>
					<ea:GridColumn Width="24" DataMember="Definicja.Nazwa" Caption="Nazwa nieobecności" ID="colNazwa"></ea:GridColumn>
					<ea:GridColumn Caption="Przyczyna nieobecności/zwolnienia" ID="colPrzyczyna" NoWrap="True"></ea:GridColumn>
					<ea:GridColumn Width="10" Align="Center" Caption="Leczenie szpitalne" ID="colLSzpitalne" NoWrap="True"></ea:GridColumn>
					<ea:GridColumn Width="11" Align="Center" DataMember="Okres.From" Caption="Od dnia" ID="colOd"></ea:GridColumn>
					<ea:GridColumn Width="11" Align="Center" DataMember="Okres.To" Caption="Do dnia" ID="colDo"></ea:GridColumn>
				    <ea:GridColumn ID="colDniKalend" runat="server" Align="Right" Width="11" Caption="Dni kalend."></ea:GridColumn>
				    <ea:GridColumn ID="colDniPracy" runat="server" Align="Right" Width="11" Caption="Dni pracy"></ea:GridColumn>
				    <ea:GridColumn ID="colCzas" runat="server" Align="Right" Width="11" Caption="Liczba godz."></ea:GridColumn>
				</Columns>
			</ea:grid><cc1:reportfooter id="ReportFooter1" runat="server" TheEnd="False"></cc1:reportfooter></form>
	</body>
</HTML>

